/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths.area_condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.block_growths.area_condition.AreaCondition;
import com.ordana.immersive_weathering.data.block_growths.growths.ConfigurableBlockGrowth;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3825;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6885;
import net.minecraft.class_6895;

record AreaCheck(int rX, int rY, int rZ, int requiredAmount, Optional<Integer> yOffset, Optional<class_3825> mustHavePredicate, Optional<class_3825> mustNotHavePredicate, Optional<class_6885<class_2248>> extraIncluded) implements AreaCondition
{
    public static final String NAME = "generate_if_not_too_many";
    public static final Codec<AreaCheck> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("radiusX").forGetter(AreaCheck::rX), (App)Codec.INT.fieldOf("radiusY").forGetter(AreaCheck::rY), (App)Codec.INT.fieldOf("radiusZ").forGetter(AreaCheck::rZ), (App)Codec.INT.fieldOf("requiredAmount").forGetter(AreaCheck::requiredAmount), (App)Codec.INT.optionalFieldOf("yOffset").forGetter(AreaCheck::yOffset), (App)class_3825.field_25012.optionalFieldOf("must_have").forGetter(AreaCheck::mustHavePredicate), (App)class_3825.field_25012.optionalFieldOf("must_not_have").forGetter(AreaCheck::mustNotHavePredicate), (App)class_6895.method_40340((class_5321)class_2378.field_25105).optionalFieldOf("includes").forGetter(AreaCheck::extraIncluded)).apply((Applicative)instance, AreaCheck::new));
    static final AreaCondition.AreaConditionType<AreaCheck> TYPE = new AreaCondition.AreaConditionType<AreaCheck>(CODEC, "generate_if_not_too_many");

    public AreaCondition.AreaConditionType<AreaCheck> getType() {
        return TYPE;
    }

    @Override
    public boolean test(class_2338 pos, class_1937 level, ConfigurableBlockGrowth config) {
        if (this.yOffset.isPresent()) {
            pos = pos.method_10086(this.yOffset.get().intValue());
        }
        int count = 0;
        class_5819 random = class_5819.method_43049((long)class_3532.method_15389((class_2382)pos));
        boolean hasRequirement = this.mustHavePredicate.isEmpty();
        List<class_2338> list = WeatheringHelper.grabBlocksAroundRandomly(pos, this.rX, this.rY, this.rZ);
        for (class_2338 p : list) {
            class_2680 state = level.method_8320(p);
            if (config.getPossibleBlocks().contains(state.method_26204()) || this.extraIncluded.isPresent() && state.method_40143(this.extraIncluded.get())) {
                ++count;
            }
            if (!hasRequirement && this.mustHavePredicate.get().method_16768(state, random)) {
                hasRequirement = true;
                if (this.requiredAmount == -1) {
                    break;
                }
            } else if (this.mustNotHavePredicate.isPresent() && this.mustNotHavePredicate.get().method_16768(state, random)) {
                return false;
            }
            if (count < this.requiredAmount) continue;
            return false;
        }
        return hasRequirement;
    }

    @Override
    public int getMaxRange() {
        return Math.max(this.rX, Math.max(this.rY, this.rZ));
    }
}

